/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.cli.service;

import java.io.File;
import java.nio.file.Path;
import lombok.Generated;
import net.schembs.solutions.dms.cli.document.api.model.DocumentCreateRequest;
import net.schembs.solutions.dms.supportedfiles.FileDescriptionDetector;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DocumentStoreService {
    private static final String ROOT_PATH = "/v2/documents";
    private final RestTemplate documentStoreRestTemplate;
    private final FileDescriptionDetector fileDescriptionDetector;

    public boolean uploadDocument(Path path, byte[] data) {
        String name = path.getFileName().toString();
        String description = this.resolveDescription(path.getFileName().toFile());
        DocumentCreateRequest request = DocumentCreateRequest.builder().name(name).description(description).data(data).build();
        this.documentStoreRestTemplate.postForObject("/v2/documents/create", (Object)request, Void.class, new Object[0]);
        return true;
    }

    private String resolveDescription(File file) {
        return this.fileDescriptionDetector.getFileDescription(file);
    }

    @Generated
    public DocumentStoreService(RestTemplate documentStoreRestTemplate, FileDescriptionDetector fileDescriptionDetector) {
        this.documentStoreRestTemplate = documentStoreRestTemplate;
        this.fileDescriptionDetector = fileDescriptionDetector;
    }
}

