/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.cli.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import net.schembs.solutions.dms.cli.model.arguments.ConfigureArguments;
import net.schembs.solutions.dms.cli.service.CliConsole;
import org.assertj.core.util.Strings;

public class ConfigurationService {
    private final CliConsole console;
    private final ObjectMapper objectMapper = this.createObjectMapper();

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    public void configure(ConfigureArguments configureArguments) {
        try {
            ConfigureArguments existing = this.load();
            existing.apply(configureArguments);
            if (System.console() != null) {
                String defaultUrl = existing.getBackendUrl();
                if (defaultUrl == null) {
                    defaultUrl = "https://store.system.sitc-dms.de";
                }
                existing.setBackendUrl(this.readValue("Backend Url", defaultUrl));
                existing.setUsername(this.readValue("Username", existing.getUsername()));
                existing.setPassword(this.readValue("Password", existing.getPassword(), true));
            } else {
                this.console.log("There is no console. Try running from the command line.", new Object[0]);
            }
            this.save(existing);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readValue(String label, String prevValue) {
        return this.readValue(label, prevValue, false);
    }

    private String readValue(String label, String prevValue, boolean hide) {
        String result = hide ? new String(System.console().readPassword("%s (%s): ".formatted(label, "***"), new Object[0])) : System.console().readLine("%s (%s): ".formatted(label, prevValue == null ? "" : prevValue), new Object[0]);
        return Strings.isNullOrEmpty((String)result) ? prevValue : result;
    }

    private void save(ConfigureArguments configureArguments) throws IOException {
        Path path = this.getDefaultConfigFilename();
        String s = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)configureArguments);
        Files.writeString(path, (CharSequence)s, new OpenOption[0]);
    }

    public ConfigureArguments load() throws IOException {
        Path path = this.getDefaultConfigFilename();
        if (path.toFile().exists()) {
            String s = Files.readString(path);
            return (ConfigureArguments)this.objectMapper.readValue(s, ConfigureArguments.class);
        }
        return new ConfigureArguments();
    }

    private Path getDefaultConfigFilename() {
        String userHome = System.getProperty("user.home");
        Path path = Paths.get(userHome, ".sitc-dms", "cli", "config");
        path.getParent().toFile().mkdirs();
        return path;
    }

    @Generated
    public ConfigurationService(CliConsole console) {
        this.console = console;
    }
}

