/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.cli.model.arguments;

import com.beust.jcommander.Parameter;
import java.nio.file.Path;
import java.util.List;
import lombok.Generated;
import net.schembs.solutions.dms.cli.model.arguments.ConfigureArguments;
import org.assertj.core.util.Strings;

public class UploadArguments {
    @Parameter(description="Files-To-Upload", required=true)
    private List<Path> files;
    @Parameter(names={"-u", "--user", "--username"}, description="Username for the SITC-DMS", required=true)
    private String username;
    @Parameter(names={"-p", "--password"}, description="Password for the SITC-DMS", required=true)
    private String password;
    @Parameter(names={"-b", "--backend", "--backend-url"}, description="Url of the SITC-DMS backend", required=true)
    private String backendUrl;
    @Parameter(names={"-g", "--gui"}, description="Shows progress etc. in gui")
    private boolean gui;
    @Parameter(names={"--parent"}, description="Name of the parent process")
    private String parent;

    private void apply(UploadArguments uploadArguments) {
        this.files = uploadArguments.files;
        this.username = uploadArguments.username;
        this.password = uploadArguments.password;
        this.backendUrl = uploadArguments.backendUrl;
    }

    public void apply(ConfigureArguments configureArguments) {
        if (!Strings.isNullOrEmpty((String)configureArguments.getUsername())) {
            this.username = configureArguments.getUsername();
        }
        if (!Strings.isNullOrEmpty((String)configureArguments.getPassword())) {
            this.password = configureArguments.getPassword();
        }
        if (!Strings.isNullOrEmpty((String)configureArguments.getBackendUrl())) {
            this.backendUrl = configureArguments.getBackendUrl();
        }
    }

    public String toSecureString() {
        UploadArguments secureArguments = new UploadArguments();
        secureArguments.apply(this);
        secureArguments.password = "***";
        return secureArguments.toString();
    }

    @Generated
    public UploadArguments() {
    }

    @Generated
    public List<Path> getFiles() {
        return this.files;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getBackendUrl() {
        return this.backendUrl;
    }

    @Generated
    public boolean isGui() {
        return this.gui;
    }

    @Generated
    public String getParent() {
        return this.parent;
    }

    @Generated
    public void setFiles(List<Path> files) {
        this.files = files;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setBackendUrl(String backendUrl) {
        this.backendUrl = backendUrl;
    }

    @Generated
    public void setGui(boolean gui) {
        this.gui = gui;
    }

    @Generated
    public void setParent(String parent) {
        this.parent = parent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadArguments)) {
            return false;
        }
        UploadArguments other = (UploadArguments)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isGui() != other.isGui()) {
            return false;
        }
        List this$files = this.getFiles();
        List other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$backendUrl = this.getBackendUrl();
        String other$backendUrl = other.getBackendUrl();
        if (this$backendUrl == null ? other$backendUrl != null : !this$backendUrl.equals(other$backendUrl)) {
            return false;
        }
        String this$parent = this.getParent();
        String other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UploadArguments;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGui() ? 79 : 97);
        List $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $backendUrl = this.getBackendUrl();
        result = result * 59 + ($backendUrl == null ? 43 : $backendUrl.hashCode());
        String $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UploadArguments(files=" + String.valueOf(this.getFiles()) + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", backendUrl=" + this.getBackendUrl() + ", gui=" + this.isGui() + ", parent=" + this.getParent() + ")";
    }
}

