/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.cli.config;

import lombok.Generated;
import net.schembs.solutions.dms.security.service.AuthService;
import net.schembs.solutions.dms.security.service.BackendUrlProvider;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

@Configuration
public class DocumentStoreConfig {
    @Bean
    public RestTemplate documentStoreRestTemplate(AuthService authService, BackendUrlProvider backendUrlProvider) {
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        return restTemplateBuilder.rootUri(backendUrlProvider.getBackendUrl()).additionalInterceptors(new ClientHttpRequestInterceptor[]{(request, body, execution) -> {
            if (authService != null && authService.isAuthenticated()) {
                request.getHeaders().add("Authorization", "Bearer " + authService.getUser().getAccessToken());
            }
            return execution.execute(request, body);
        }}).build();
    }

    @Generated
    public DocumentStoreConfig() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentStoreConfig)) {
            return false;
        }
        DocumentStoreConfig other = (DocumentStoreConfig)o;
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocumentStoreConfig;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "DocumentStoreConfig()";
    }
}

