/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.cli;

import com.beust.jcommander.JCommander;
import java.awt.EventQueue;
import java.io.IOException;
import lombok.Generated;
import net.schembs.solutions.dms.cli.model.ParentWindow;
import net.schembs.solutions.dms.cli.model.arguments.ConfigureArguments;
import net.schembs.solutions.dms.cli.model.arguments.UploadArguments;
import net.schembs.solutions.dms.cli.model.arguments.VersionArguments;
import net.schembs.solutions.dms.cli.service.CliConsole;
import net.schembs.solutions.dms.cli.service.ConfigurationService;
import net.schembs.solutions.dms.cli.service.UploadService;
import net.schembs.solutions.dms.cli.ui.AboutWindow;
import net.schembs.solutions.dms.cli.ui.MainFrame;
import net.schembs.solutions.dms.cli.ui.MainFrameImpl;
import net.schembs.solutions.dms.cli.ui.nogui.DummyMainFrame;
import net.schembs.solutions.dms.cli.ui.osspecific.OperatingSystem;
import net.schembs.solutions.dms.security.service.BackendUrlProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

@SpringBootApplication
public class DmsCLIApp
implements ApplicationContextInitializer<GenericApplicationContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmsCLIApp.class);
    private UploadArguments arguments;
    private MainFrame mainFrame;

    public static void main(String[] args) throws IOException {
        System.setProperty("apple.awt.UIElement", "true");
        CliConsole console = new CliConsole();
        ConfigurationService configurationService = new ConfigurationService(console);
        ConfigureArguments configureArguments = configurationService.load();
        VersionArguments versonArguments = new VersionArguments();
        UploadArguments uploadArguments = new UploadArguments();
        uploadArguments.apply(configureArguments);
        JCommander commander = JCommander.newBuilder().addCommand("configure", (Object)configureArguments, new String[0]).addCommand("upload", (Object)uploadArguments, new String[0]).addCommand("version", (Object)versonArguments, new String[0]).programName("dms-cli").build();
        try {
            commander.parse(args);
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            commander.usage();
            System.exit(1);
        }
        DmsCLIApp app = new DmsCLIApp();
        if (commander.getParsedCommand() != null) {
            switch (commander.getParsedCommand()) {
                case "configure": {
                    app.configure(configureArguments, console);
                    break;
                }
                case "upload": {
                    app.upload(uploadArguments);
                    break;
                }
                case "version": {
                    app.version(versonArguments.isGui(), console);
                }
            }
        } else {
            commander.usage();
        }
    }

    private void version(boolean isGui, CliConsole console) {
        this.arguments = new UploadArguments();
        ConfigurableApplicationContext ctx = new SpringApplicationBuilder(new Class[]{DmsCLIApp.class}).headless(false).web(WebApplicationType.NONE).initializers(new ApplicationContextInitializer[]{this}).profiles(new String[]{OperatingSystem.getProfile()}).run(new String[0]);
        if (isGui) {
            OperatingSystem.setupPLaF();
            ((AboutWindow)ctx.getBean(AboutWindow.class)).show(null);
            System.exit(0);
        } else {
            console.log(((AboutWindow)ctx.getBean(AboutWindow.class)).getFullVersion(), new Object[0]);
        }
    }

    private void configure(ConfigureArguments configureArguments, CliConsole console) {
        new ConfigurationService(console).configure(configureArguments);
    }

    private void upload(UploadArguments arguments) {
        if (arguments.isGui()) {
            OperatingSystem.setupPLaF();
            this.initUI(arguments);
        } else {
            this.initDummyBeans();
        }
        this.arguments = arguments;
        ConfigurableApplicationContext ctx = new SpringApplicationBuilder(new Class[]{DmsCLIApp.class}).headless(true).web(WebApplicationType.NONE).initializers(new ApplicationContextInitializer[]{this}).profiles(new String[]{OperatingSystem.getProfile()}).run(new String[0]);
        log.info(arguments.toSecureString());
        EventQueue.invokeLater(() -> {
            UploadService uploadService = (UploadService)ctx.getBean(UploadService.class);
            uploadService.upload(arguments);
        });
    }

    private void initUI(UploadArguments arguments) {
        ParentWindow parentWindow = OperatingSystem.getParentWindow((String)arguments.getParent());
        this.mainFrame = new MainFrameImpl();
        this.mainFrame.createUI(parentWindow);
        this.mainFrame.getFilesPanel().setTitle("Prepare upload of %d files".formatted(arguments.getFiles().size()));
        this.mainFrame.getFilesPanel().setSubTitle("Initializing...");
        this.mainFrame.setVisible(true);
    }

    private void initDummyBeans() {
        this.mainFrame = new DummyMainFrame();
    }

    public void initialize(GenericApplicationContext applicationContext) {
        applicationContext.registerBean(BackendUrlProvider.class, () -> () -> this.arguments.getBackendUrl(), new BeanDefinitionCustomizer[0]);
        applicationContext.registerBean(MainFrame.class, () -> this.mainFrame, new BeanDefinitionCustomizer[0]);
    }
}

